<?php

namespace App/Models/;

class Offer extends Eloquent {

	protected $table = 'offers';
	public $timestamps = true;
	protected $fillable = array('promo_code', 'views', 'expiry_date', 'patient_count');

	public function doctors()
	{
		return $this->morphedByMany('Doctor', 'offerable');
	}

	public function patients()
	{
		return $this->morphedByMany('Patient', 'offerable');
	}

}