<?php

namespace App/Models/;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Payment extends Eloquent {

	protected $table = 'payments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('credit_card_number', 'card_holder_name', 'expiry_date', 'cvv_code', 'doctor_id', 'patient_id', 'payment_method_id', 'softDeletes');

	public function patient()
	{
		return $this->hasOne('Patient');
	}

	public function doctor_id()
	{
		return $this->hasOne('Patient');
	}

	public function methods()
	{
		return $this->hasMany('PaymentMethod');
	}

}