<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExpertDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('expert_documents', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('expert_id')->unsigned();
			$table->string('file_name', 255);
			$table->string('file_address', 500);
			$table->boolean('is_public');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('expert_documents');
	}
}