<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('contributeur', function(Blueprint $table) {
			$table->foreign('projet_id')->references('id')->on('projet')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projet', function(Blueprint $table) {
			$table->foreign('contributeur_id')->references('id')->on('contributeur')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('acteur', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('type_acteur')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('acteur', function(Blueprint $table) {
			$table->foreign('projet_id')->references('id')->on('projet')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('intermediaires', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('type_intermediaire')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('intermediaires', function(Blueprint $table) {
			$table->foreign('projet_id')->references('id')->on('projet')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('beneficiaire', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('type_beneficiaire')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('beneficiaire', function(Blueprint $table) {
			$table->foreign('acteur_id')->references('id')->on('acteur')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('equipement', function(Blueprint $table) {
			$table->foreign('projet_id')->references('id')->on('projet')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pivot_type_equipement', function(Blueprint $table) {
			$table->foreign('equipement_id')->references('id')->on('equipement')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pivot_type_equipement', function(Blueprint $table) {
			$table->foreign('type_equipement_id')->references('id')->on('type_equipement')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pivot_type_projet', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('type_projet')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pivot_type_projet', function(Blueprint $table) {
			$table->foreign('projet_id')->references('id')->on('projet')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('contributeur', function(Blueprint $table) {
			$table->dropForeign('contributeur_projet_id_foreign');
		});
		Schema::table('projet', function(Blueprint $table) {
			$table->dropForeign('projet_contributeur_id_foreign');
		});
		Schema::table('acteur', function(Blueprint $table) {
			$table->dropForeign('acteur_type_id_foreign');
		});
		Schema::table('acteur', function(Blueprint $table) {
			$table->dropForeign('acteur_projet_id_foreign');
		});
		Schema::table('intermediaires', function(Blueprint $table) {
			$table->dropForeign('intermediaires_type_id_foreign');
		});
		Schema::table('intermediaires', function(Blueprint $table) {
			$table->dropForeign('intermediaires_projet_id_foreign');
		});
		Schema::table('beneficiaire', function(Blueprint $table) {
			$table->dropForeign('beneficiaire_type_id_foreign');
		});
		Schema::table('beneficiaire', function(Blueprint $table) {
			$table->dropForeign('beneficiaire_acteur_id_foreign');
		});
		Schema::table('equipement', function(Blueprint $table) {
			$table->dropForeign('equipement_projet_id_foreign');
		});
		Schema::table('pivot_type_equipement', function(Blueprint $table) {
			$table->dropForeign('pivot_type_equipement_equipement_id_foreign');
		});
		Schema::table('pivot_type_equipement', function(Blueprint $table) {
			$table->dropForeign('pivot_type_equipement_type_equipement_id_foreign');
		});
		Schema::table('pivot_type_projet', function(Blueprint $table) {
			$table->dropForeign('pivot_type_projet_type_id_foreign');
		});
		Schema::table('pivot_type_projet', function(Blueprint $table) {
			$table->dropForeign('pivot_type_projet_projet_id_foreign');
		});
	}
}