<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->json('name');
			$table->integer('rate')->nullable();
			$table->json('description');
			$table->double('price')->nullable();
			$table->json('requirements')->nullable();
			$table->date('date')->nullable();
			$table->integer('language_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->string('url');
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}