<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->decimal('lat', 10,6)->nullable();
			$table->decimal('lng', 10,6)->nullable();
			$table->string('login_method')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}