<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCollectionOrdersTable extends Migration {

	public function up()
	{
		Schema::create('Collection_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('maak_customer_id')->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->string('order_number', 100)->nullable();
			$table->string('Title', 100)->nullable();
			$table->longText('Descaption')->nullable();
			$table->enum('Type', array('compinent', 'proofe_deth', 'proofe_invslovenacy'))->nullable();
			$table->boolean('status')->nullable()->default(1);
		});
	}

	public function down()
	{
		Schema::drop('Collection_orders');
	}
}