<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOutcomesTable extends Migration {

	public function up()
	{
		Schema::create('outcomes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('bond_no', 100)->nullable();
			$table->double('amount')->nullable();
			$table->integer('employee_id')->nullable();
			$table->integer('vendor_id')->unsigned()->nullable();
			$table->enum('dealing', array('Customer', 'AccountCode', 'ServiceProvider'))->nullable();
			$table->integer('source_treasury_id')->unsigned()->nullable();
			$table->integer('destination_treasury_id')->unsigned()->nullable();
			$table->integer('management_id')->nullable();
			$table->enum('pay_type', array('bank', 'cash'))->nullable();
			$table->integer('customer_id')->unsigned()->nullable();
			$table->integer('system_account_id')->unsigned()->nullable();
			$table->json('attachments')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('outcomes');
	}
}