<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTmbJackCustomersTable extends Migration {

	public function up()
	{
		Schema::create('tmb_jack_customers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id');
			$table->string('comercial_number', 100);
			$table->string('tax_number', 100)->nullable();
			$table->double('dues')->nullable();
			$table->date('last_settlement_date')->nullable();
			$table->integer('marketer_id')->nullable();
			$table->double('daily_expected_amount')->nullable();
			$table->enum('registration_type', array('company', 'document'));
			$table->string('manger_name', 100)->nullable();
			$table->double('discount')->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->enum('clasification_n', array('vip', 'multi_branch', 'one_branch'))->nullable();
			$table->bigInteger('manager_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tmb_jack_customers');
	}
}