<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTmpCustomersTable extends Migration {

	public function up()
	{
		Schema::create('tmp_customers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->integer('national_id');
			$table->string('phone', 20);
			$table->string('role_type', 100);
			$table->boolean('status')->default(1);
			$table->timestamps();
			$table->softDeletes();
			$table->double('expected_sales_price')->nullable();
			$table->double('expected_activity_price')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tmp_customers');
	}
}