<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTmpPayCustomerCardsTable extends Migration {

	public function up()
	{
		Schema::create('tmp_pay_customer_cards', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('pay_customer_id');
			$table->double('amount')->nullable();
			$table->enum('type', array('basic', 'gold', 'platinum'));
			$table->boolean('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tmp_pay_customer_cards');
	}
}