<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTreasuryTransfersTable extends Migration {

	public function up()
	{
		Schema::create('treasury_transfers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('transfer_number', 100)->nullable();
			$table->double('amount')->nullable();
			$table->integer('employee_id')->nullable();
			$table->enum('transfer_type', array('cash', 'check'));
			$table->integer('source_treasury_id')->unsigned()->nullable();
			$table->integer('destination_treasury_id')->unsigned()->nullable();
			$table->text('Notes')->nullable();
			$table->integer('bank_id')->unsigned()->nullable();
			$table->string('check_number', 100)->nullable();
			$table->date('check_date')->nullable();
			$table->json('attachments')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('treasury_transfers');
	}
}