<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIncomeTypesTable extends Migration {

	public function up()
	{
		Schema::create('income_types', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 100)->nullable();
			$table->text('note')->nullable();
			$table->boolean('status')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('income_types');
	}
}