<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalConsultingTextsTable extends Migration {

	public function up()
	{
		Schema::create('legal_consulting_texts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('consulting_id')->unsigned()->nullable();
			$table->longText('note')->nullable();
			$table->enum('status', array('replied', 'pending'));
		});
	}

	public function down()
	{
		Schema::drop('legal_consulting_texts');
	}
}