<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalJudicialDepartmentsTable extends Migration {

	public function up()
	{
		Schema::create('legal_judicial_departments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('region_id')->unsigned()->nullable();
			$table->bigInteger('court_id')->unsigned()->nullable();
			$table->string('name', 100)->nullable();
			$table->longText('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('legal_judicial_departments');
	}
}