<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalPowerAttorneyTable extends Migration {

	public function up()
	{
		Schema::create('legal_power_attorney', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('attorney_number', 100)->nullable();
			$table->bigInteger('attorney_type_id')->unsigned();
			$table->enum('attorney_status', array('active', 'cancelled', 'expired'))->nullable();
			$table->smallInteger('duration')->nullable();
			$table->enum('category', array('self_attorney', 'attorney_to_attorney'))->nullable();
			$table->string('previous_attorney_number', 100)->nullable();
			$table->bigInteger('country_id')->unsigned()->nullable();
			$table->bigInteger('client_employee')->unsigned()->nullable();
			$table->bigInteger('agent_employee')->nullable();
			$table->bigInteger('power_attorney_text_id')->unsigned()->nullable();
			$table->bigInteger('power_attorney_item_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('legal_power_attorney');
	}
}