<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestrictionItemsTable extends Migration {

	public function up()
	{
		Schema::create('restriction_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('system_account_id')->unsigned()->nullable();
			$table->enum('type', array('from', 'to'))->nullable();
			$table->integer('managment_id')->nullable();
			$table->double('amount')->nullable();
			$table->text('note')->nullable();
			$table->integer('accounting_restriction_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('restriction_items');
	}
}