<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRiskAlertSettingItemsTable extends Migration {

	public function up()
	{
		Schema::create('risk_alert_setting_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('field', array('daily', 'monthly', 'yearly', 'transactionvalue'))->nullable();
			$table->enum('coefficient', array('<', '>', '=', '<=', '>=', '!='));
			$table->string('value', 150)->nullable();
			$table->bigInteger('parent')->unsigned()->nullable();
			$table->enum('conection_type', array('And', 'Or'))->nullable();
			$table->boolean('status')->nullable()->default(1);
			$table->bigInteger('alert_setting_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('risk_alert_setting_items');
	}
}