<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->json('name');
			$table->json('description');
			$table->enum('type', array('single', 'bundle'));
			$table->enum('status', array('published', 'draft', 'inactive'));
			$table->json('slug');
			$table->decimal('price', 2);
			$table->enum('discount_type', array('percentage', 'no_discount', 'fixed'));
			$table->boolean('in_stock')->default(1);
			$table->boolean('is_new');
			$table->boolean('is_featured');
			$table->bigInteger('category_id')->unsigned();
			$table->string('vat');
			$table->json('meta_title');
			$table->json('meta_description');
			$table->json('meta_keywords');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}