<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('country');
			$table->string('city');
			$table->string('street');
			$table->boolean('is_default');
			$table->timestamps();
			$table->string('lat');
			$table->string('lng');
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}