<?php

namespace UserProfile;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserProfile extends Eloquent {

	protected $table = 'user_survey_profiles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user_suburb()
	{
		return $this->hasMany('UserSuburb');
	}

	public function property_user()
	{
		return $this->hasMany('PropertyUser');
	}

	public function more_refine_serch()
	{
		return $this->hasMany('MoreRefineSearch', 'user_profile_id');
	}

	public function userPriceRanges()
	{
		return $this->hasOne('UserPriceRenge');
	}

	public function userPropertyType()
	{
		return $this->hasOne('UserPropertyType');
	}

	public function userBadRoom()
	{
		return $this->hasOne('UserBadRoom');
	}

	public function userMoveIn()
	{
		return $this->hasOne('UserMoveIn');
	}

}