<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid');
			$table->string('company_type_id');
			$table->integer('parent_id');
			$table->string('name');
			$table->text('address');
			$table->integer('city_id');
			$table->string('zip_code');
			$table->string('phone');
			$table->string('email');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}