<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid');
			$table->integer('company_id');
			$table->integer('project_owner_id');
			$table->integer('project_category_id');
			$table->string('name');
			$table->datetime('starting_date');
			$table->datetime('expected_finish_date');
			$table->text('desc');
			$table->integer('created_by');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}