<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRevenueTable extends Migration {

	public function up()
	{
		Schema::create('revenue', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('ticket_id')->unsigned();
			$table->integer('buyer_id')->unsigned();
			$table->integer('seller_id')->unsigned();
			$table->enum('type', array('seller', 'buyer'))->nullable();
			$table->string('revenue_percentage')->nullable();
			$table->string('amount')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('revenue');
	}
}