<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContentsTable extends Migration {

	public function up()
	{
		Schema::create('contents', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 55);
			$table->string('shortDescription', 155);
			$table->string('body', 2048);
			$table->string('hashtags', 155);
			$table->integer('content_type_id')->unsigned();
			$table->integer('contenteable_id')->unsigned()->nullable();
			$table->string('contenteable_type')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('contents');
	}
}