<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVisitingLogsTable extends Migration {

	public function up()
	{
		Schema::create('visiting_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('children_list');
			$table->integer('account_number')->unsigned();
			$table->integer('visitor_id');
			$table->integer('appointment_id');
			$table->datetime('visit_start_time');
			$table->datetime('visit_end_time');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('visiting_logs');
	}
}