<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientAccount extends Model 
{

    protected $table = 'client_account';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('account_id', 'client_id', 'value');

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

    public function account()
    {
        return $this->belongsTo('Account', 'account_id');
    }

}