<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConversationTable extends Migration {

	public function up()
	{
		Schema::create('conversation', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('seller_id')->nullable();
			$table->text('last_message')->nullable();
			$table->boolean('read')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('conversation');
	}
}