<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlanRequestTable extends Migration {

	public function up()
	{
		Schema::create('plan_request', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('plan_id');
			$table->tinyInteger('is_custom');
			$table->tinyInteger('status');
			$table->string('lat', 255);
			$table->string('long', 255);
			$table->string('adress', 2000);
			$table->string('remark', 2000);
			$table->longText('description');
			$table->tinyInteger('is_active');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('plan_request');
	}
}