<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('cc', 10);
			$table->string('mobile', 255);
			$table->string('image', 255)->nullable();
			$table->tinyInteger('role_id');
			$table->tinyInteger('notification_active')->default('1');
			$table->tinyInteger('is_active')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}