<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdjustmentsTable extends Migration {

	public function up()
	{
		Schema::create('adjustments', function(Blueprint $table) {
			$table->integer('id', true);
			$table->integer('variant_id');
			$table->integer('location_id')->unsigned();
			$table->string('type');
			$table->decimal('amount');
			$table->json('metadata');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('adjustments');
	}
}