<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('variant_tags', function(Blueprint $table) {
			$table->foreign('variant_id')->references('id')->on('variants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('variant_tags', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('category_filters', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('category_filters', function(Blueprint $table) {
			$table->foreign('filter_id')->references('id')->on('filters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('variants', function(Blueprint $table) {
			$table->foreign('vehicle_id')->references('id')->on('vehicles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('location_prices', function(Blueprint $table) {
			$table->foreign('variant_id')->references('id')->on('variants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('location_prices', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('color_options', function(Blueprint $table) {
			$table->foreign('variant_id')->references('id')->on('variants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('dealers', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('dealer_brands', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('dealer_brands', function(Blueprint $table) {
			$table->foreign('dealer_id')->references('id')->on('dealers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('filter_tag', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('filter_tag', function(Blueprint $table) {
			$table->foreign('filter_id')->references('id')->on('filters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('adjustments', function(Blueprint $table) {
			$table->foreign('variant_id')->references('id')->on('variants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('adjustments', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_brand_id_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_category_id_foreign');
		});
		Schema::table('variant_tags', function(Blueprint $table) {
			$table->dropForeign('variant_tags_variant_id_foreign');
		});
		Schema::table('variant_tags', function(Blueprint $table) {
			$table->dropForeign('variant_tags_tag_id_foreign');
		});
		Schema::table('category_filters', function(Blueprint $table) {
			$table->dropForeign('category_filters_category_id_foreign');
		});
		Schema::table('category_filters', function(Blueprint $table) {
			$table->dropForeign('category_filters_filter_id_foreign');
		});
		Schema::table('variants', function(Blueprint $table) {
			$table->dropForeign('variants_vehicle_id_foreign');
		});
		Schema::table('location_prices', function(Blueprint $table) {
			$table->dropForeign('location_prices_variant_id_foreign');
		});
		Schema::table('location_prices', function(Blueprint $table) {
			$table->dropForeign('location_prices_location_id_foreign');
		});
		Schema::table('color_options', function(Blueprint $table) {
			$table->dropForeign('color_options_variant_id_foreign');
		});
		Schema::table('dealers', function(Blueprint $table) {
			$table->dropForeign('dealers_location_id_foreign');
		});
		Schema::table('dealer_brands', function(Blueprint $table) {
			$table->dropForeign('dealer_brands_brand_id_foreign');
		});
		Schema::table('dealer_brands', function(Blueprint $table) {
			$table->dropForeign('dealer_brands_dealer_id_foreign');
		});
		Schema::table('filter_tag', function(Blueprint $table) {
			$table->dropForeign('filter_tag_tag_id_foreign');
		});
		Schema::table('filter_tag', function(Blueprint $table) {
			$table->dropForeign('filter_tag_filter_id_foreign');
		});
		Schema::table('adjustments', function(Blueprint $table) {
			$table->dropForeign('adjustments_variant_id_foreign');
		});
		Schema::table('adjustments', function(Blueprint $table) {
			$table->dropForeign('adjustments_location_id_foreign');
		});
	}
}