<?php

namespace App\Models;

class DonationRequest extends Eloquent {

	protected $table = 'donation_requests';
	public $timestamps = true;
	protected $fillable = array('patient_name', 'patient_age', 'hospital_name', 'hospital_address', 'phone', 'notes', 'latitude', 'longitude', 'bags_num');

	public function blood_types()
	{
		return $this->belongsTo('BloodType');
	}

	public function clients()
	{
		return $this->belongsTo('Clients');
	}

	public function cities()
	{
		return $this->belongsTo('Cities');
	}

	public function notifications()
	{
		return $this->hasOne('Notification');
	}

}