<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFarmsTable extends Migration {

	public function up()
	{
		Schema::create('farms', function(Blueprint $table) {
			$table->increments('id');
			$table->string('reg_id')->index();
			$table->string('name')->index();
			$table->string('owner_name');
			$table->jsonb('milk_tank_no');
			$table->string('member_place')->index();
			$table->integer('vet_id');
			$table->string('phone');
			$table->jsonb('address');
			$table->string('location');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('farms');
	}
}