<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('schoollevels', function(Blueprint $table) {
			$table->foreign('sid')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('athlete_records', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('athlete_records', function(Blueprint $table) {
			$table->foreign('sport_id')->references('id')->on('sports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('athlete_records', function(Blueprint $table) {
			$table->foreign('organisation_id')->references('id')->on('sport_organisations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('graduates', function(Blueprint $table) {
			$table->foreign('sid')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sport_achievements', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sport_achievements', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('sport_events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sport_competitions', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('sport_games')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('sport_events', function(Blueprint $table) {
			$table->foreign('competition_id')->references('id')->on('sport_competitions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sport_events', function(Blueprint $table) {
			$table->foreign('sport_id')->references('id')->on('sports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('schoollevels', function(Blueprint $table) {
			$table->dropForeign('schoollevels_sid_foreign');
		});
		Schema::table('athlete_records', function(Blueprint $table) {
			$table->dropForeign('athlete_records_student_id_foreign');
		});
		Schema::table('athlete_records', function(Blueprint $table) {
			$table->dropForeign('athlete_records_sport_id_foreign');
		});
		Schema::table('athlete_records', function(Blueprint $table) {
			$table->dropForeign('athlete_records_organisation_id_foreign');
		});
		Schema::table('graduates', function(Blueprint $table) {
			$table->dropForeign('graduates_sid_foreign');
		});
		Schema::table('sport_achievements', function(Blueprint $table) {
			$table->dropForeign('sport_achievements_student_id_foreign');
		});
		Schema::table('sport_achievements', function(Blueprint $table) {
			$table->dropForeign('sport_achievements_event_id_foreign');
		});
		Schema::table('sport_competitions', function(Blueprint $table) {
			$table->dropForeign('sport_competitions_game_id_foreign');
		});
		Schema::table('sport_events', function(Blueprint $table) {
			$table->dropForeign('sport_events_competition_id_foreign');
		});
		Schema::table('sport_events', function(Blueprint $table) {
			$table->dropForeign('sport_events_sport_id_foreign');
		});
	}
}