<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDatabasesTable extends Migration {

	public function up()
	{
		Schema::create('databases', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->unique();
			$table->string('status')->nullable();
			$table->string('hash')->unique()->nullable();
			$table->string('description');
			$table->string('jwt_secret');
			$table->string('username');
			$table->string('password');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('databases');
	}
}