<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('identities', function(Blueprint $table) {
			$table->foreign('database_id')->references('id')->on('databases')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->foreign('database_id')->references('id')->on('databases')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('identities', function(Blueprint $table) {
			$table->dropForeign('identities_database_id_foreign');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->dropForeign('invites_database_id_foreign');
		});
	}
}