<?php

use Illuminate\Database\Seeder;
use App\Models\Role;

class RoleTableSeeder extends Seeder {

	public function run()
	{
		//DB::table('roles')->delete();

		// Study Nurse
		Role::create(array(
				'id' => 'SN',
				'description' => 'Study Nurse',
				'scopes' => 'site:read'
			));

		// Caregiver
		Role::create(array(
				'id' => 'CG',
				'description' => 'Caregiver',
				'scopes' => 'patient'
			));

		// Principal Investigator
		Role::create(array(
				'id' => 'PI',
				'description' => 'Principal Investigator',
				'scopes' => 'site:write,site:sign'
			));

		// Cro Clinical Director
		Role::create(array(
				'id' => 'CD',
				'description' => 'Cro Clinical Director',
				'scopes' => 'cro:*'
			));

		// Sponsor Clinical Director
		Role::create(array(
				'id' => 'SCD',
				'description' => 'Sponsor Clinical Director',
				'scopes' => '*:*'
			));

		// Project Director
		Role::create(array(
				'id' => 'PD',
				'description' => 'Project Director',
				'scopes' => '*:*'
			));

		// Cra Monitor
		Role::create(array(
				'id' => 'CR',
				'description' => 'Cra Monitor',
				'scopes' => '*.read,*.query,*.sign'
			));

		// Cta
		Role::create(array(
				'id' => 'CT',
				'description' => 'CTA',
				'scopes' => '*:read'
			));

		// Statistician
		Role::create(array(
				'id' => 'ST',
				'description' => 'Statistician',
				'scopes' => '*:read'
			));

		// Data Manager
		Role::create(array(
				'id' => 'DM',
				'description' => 'Data Manager',
				'scopes' => '*:write'
			));

		// Study Coordinator
		Role::create(array(
				'id' => 'SC',
				'description' => 'Study coordinator',
				'scopes' => 'site:write'
			));

		// Sub Investigator
		Role::create(array(
				'id' => 'SI',
				'description' => 'Sub Investigator',
				'scopes' => 'site:write,site:sign'
			));
	}
}