<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->string('slug')->unique();
			$table->longText('description')->nullable();
			$table->longText('special_feature')->nullable();
			$table->longText('applications')->nullable();
			$table->longText('specifications')->nullable();
			$table->longText('documentation')->nullable();
			$table->longText('variation')->nullable();
			$table->tinyInteger('is_feature')->nullable()->default('0');
			$table->string('catalogue')->nullable();
			$table->string('product_doc')->nullable();
			$table->tinyInteger('sort')->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}