<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerchantsTable extends Migration {

	public function up()
	{
		Schema::create('merchants', function(Blueprint $table) {
			$table->increments('id');
			$table->string('trade_name');
			$table->string('image')->nullable();
			$table->string('administrator_name');
			$table->string('merchant_serial')->unique();
			$table->string('phone')->unique();
			$table->string('email')->unique();
			$table->tinyInteger('account_status');
			$table->tinyInteger('status');
			$table->datetime('login_date');
			$table->integer('city_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('merchants');
	}
}