<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('merchants', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('governorates', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('governorates')->references('id')->on('governorates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('car_models', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('manufacture_years', function(Blueprint $table) {
			$table->foreign('car_model_id')->references('id')->on('car_models')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('engines', function(Blueprint $table) {
			$table->foreign('car_model_id')->references('id')->on('car_models')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('sub_category_id')->references('id')->on('product_sub_categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('engine_id')->references('id')->on('engines')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('merchants', function(Blueprint $table) {
			$table->dropForeign('merchants_city_id_foreign');
		});
		Schema::table('governorates', function(Blueprint $table) {
			$table->dropForeign('governorates_country_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_governorates_foreign');
		});
		Schema::table('car_models', function(Blueprint $table) {
			$table->dropForeign('car_models_brand_id_foreign');
		});
		Schema::table('manufacture_years', function(Blueprint $table) {
			$table->dropForeign('manufacture_years_car_model_id_foreign');
		});
		Schema::table('engines', function(Blueprint $table) {
			$table->dropForeign('engines_car_model_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_sub_category_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_engine_id_foreign');
		});
	}
}