<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppointmentsTable extends Migration {

	public function up()
	{
		Schema::create('appointments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('facility_id')->unsigned()->index();
			$table->integer('facility_service_id')->unsigned();
			$table->integer('inspector_id')->unsigned();
			$table->integer('supervisor_id')->unsigned();
			$table->integer('template_version_id')->unsigned();
			$table->datetime('scheduled_start')->index();
			$table->datetime('scheduled_end')->nullable();
			$table->integer('current_status_id')->unsigned();
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('appointments');
	}
}