<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFacilitiesTable extends Migration {

	public function up()
	{
		Schema::create('facilities', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unique()->unsigned();
			$table->integer('zone_id')->unsigned();
			$table->string('name');
			$table->string('license_number')->nullable();
			$table->string('location');
			$table->decimal('compliance_percentage')->default('0');
			$table->string('status');
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('facilities');
	}
}