<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFacilityRequirementSubmissionsTable extends Migration {

	public function up()
	{
		Schema::create('facility_requirement_submissions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('facility_id')->unsigned();
			$table->integer('requirement_id')->unsigned();
			$table->integer('attachment_id')->unsigned();
			$table->enum('status', array(''));
			$table->integer('reviewed_by')->unsigned()->nullable();
			$table->datetime('reviewed_at')->nullable();
			$table->text('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('facility_requirement_submissions');
	}
}