<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLookupValuesTable extends Migration {

	public function up()
	{
		Schema::create('lookup_values', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('group_id')->unique()->unsigned();
			$table->string('code');
			$table->string('label');
			$table->integer('sort_order')->default('0');
			$table->string('color')->nullable();
			$table->boolean('is_active');
		});
	}

	public function down()
	{
		Schema::drop('lookup_values');
	}
}