<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReportTemplatesTable extends Migration {

	public function up()
	{
		Schema::create('report_templates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('service_id')->unique()->unsigned();
			$table->string('name');
			$table->text('description')->nullable();
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('report_templates');
	}
}