<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTemplateVersionsTable extends Migration {

	public function up()
	{
		Schema::create('template_versions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('report_template_id')->unique()->unsigned();
			$table->string('version_number')->unique();
			$table->boolean('is_active');
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('template_versions');
	}
}