<?php

namespace facilities;

use Illuminate\Database\Eloquent\Model;

class Facilities extends Model 
{

    protected $table = 'facilities';
    public $timestamps = true;

    public function owner()
    {
        return $this->belongsTo('Users', 'user_id');
    }

    public function facilityPackages()
    {
        return $this->hasMany('Facility_packages', 'facility_id');
    }

    public function kitchens()
    {
        return $this->hasMany('Kitchens');
    }

    public function users()
    {
        return $this->belongsToMany('Users', 'facility_users');
    }

    public function applications()
    {
        return $this->hasMany('Applications');
    }

    public function appointments()
    {
        return $this->hasMany('Appointments');
    }

    public function tickets()
    {
        return $this->hasMany('Tickets');
    }

    public function attachments()
    {
        return $this->morphMany('Attachments');
    }

}