<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('cars', function(Blueprint $table) {
			$table->foreign('engine_type')->references('id')->on('engine_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cars', function(Blueprint $table) {
			$table->foreign('car_type_id')->references('id')->on('car_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cars', function(Blueprint $table) {
			$table->foreign('car_status_id')->references('id')->on('car_status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cars', function(Blueprint $table) {
			$table->foreign('station_id')->references('id')->on('station')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_cars', function(Blueprint $table) {
			$table->foreign('car_id')->references('id')->on('cars')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_cars', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('accidents', function(Blueprint $table) {
			$table->foreign('car_id')->references('id')->on('cars')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tankings', function(Blueprint $table) {
			$table->foreign('car_id')->references('id')->on('cars')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contract', function(Blueprint $table) {
			$table->foreign('car_id')->references('id')->on('cars')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('cars', function(Blueprint $table) {
			$table->dropForeign('cars_engine_type_foreign');
		});
		Schema::table('cars', function(Blueprint $table) {
			$table->dropForeign('cars_car_type_id_foreign');
		});
		Schema::table('cars', function(Blueprint $table) {
			$table->dropForeign('cars_car_status_id_foreign');
		});
		Schema::table('cars', function(Blueprint $table) {
			$table->dropForeign('cars_station_id_foreign');
		});
		Schema::table('user_cars', function(Blueprint $table) {
			$table->dropForeign('user_cars_car_id_foreign');
		});
		Schema::table('user_cars', function(Blueprint $table) {
			$table->dropForeign('user_cars_user_id_foreign');
		});
		Schema::table('accidents', function(Blueprint $table) {
			$table->dropForeign('accidents_car_id_foreign');
		});
		Schema::table('tankings', function(Blueprint $table) {
			$table->dropForeign('tankings_car_id_foreign');
		});
		Schema::table('contract', function(Blueprint $table) {
			$table->dropForeign('contract_car_id_foreign');
		});
	}
}