<?php

namespace lhp;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Analisis extends Model 
{

    protected $table = 'analisis';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('analisis_isi');
    protected $visible = array('analisis_isi');

    public function getKesimpulan()
    {
        return $this->hasOne('lhp\Kesimpulan', 'kesimpulan_id');
    }

    public function getSaran()
    {
        return $this->hasOne('lhp\Saran', 'saran_id');
    }

}